class Proj_Arrow extends Projectile;

function PostBeginPlay()
{
local rotator RandRot;
	Super.PostBeginPlay();
	Velocity = Vector(Rotation) * Speed;      // velocity
	RandRot.Pitch = FRand() * 200 - 100;
	RandRot.Yaw = FRand() * 200 - 100;
	RandRot.Roll = FRand() * 200 - 100;
	Velocity = Velocity >> RandRot;
	PlaySound(SpawnSound, SLOT_Misc, 2.0);		
}

simulated function ProcessTouch( Actor Other, Vector HitLocation )
{
local int hitdamage;
		If ( Other!=Instigator  && Arrow(Other) == none)
		{
		if ( Role == ROLE_Authority )
			Other.TakeDamage(damage, instigator,HitLocation,
				(MomentumTransfer * Normal(Velocity)), 'enforcer');
		Destroy();
		}
}

simulated function HitWall( vector HitNormal, actor Wall )
{
	Super.HitWall(HitNormal, Wall);	
	PlaySound(ImpactSound, SLOT_Misc, 0.5);
  	mesh = mesh'Burst';
  	Skin = Texture'JArrow1';
	SetPhysics(PHYS_None); 
	SetCollision(false,false,false);
	MakeNoise(0.3);
	PlayAnim   ( 'Explo', 0.9 );
}

simulated function Explode(vector HitLocation, vector HitNormal)
{
}


simulated function AnimEnd()
{
	Destroy();
}

event ZoneChange( ZoneInfo NewZone )
{
	if ( NewZone.IsA('NoPlayerZone') )
		Self.Destroy();
}	
	
defaultproperties
{
     speed=1400.000000
     Damage=1.000000
     MomentumTransfer=2000
     SpawnSound=Sound'UnrealShare.General.ArrowSpawn'
     ImpactSound=Sound'UnrealShare.Minigun.Impact2'
     RemoteRole=ROLE_SimulatedProxy
     Mesh=LodMesh'UnrealShare.ArrowM'
     bUnlit=True
	 DrawScale=0.75
}
